#ifndef QRFEAES_H
#define QRFEAES_H

#include <QByteArray>

class QrfeAES
	{
public:
	enum BlockMode 
	{
		ECB = 0, 			/* <@brief Electronic CodeBook	  - each block independent, weak */
		CBC = 1  			/* <@brief Cipher Block Chaining - most secure */
	};

	enum KeyLength 
	{
		Key128 = 128,		/* <@brief 128-Bit Key length */
		Key192 = 192,		/* <@brief 192-Bit Key length */
		Key256 = 256		/* <@brief 256-Bit Key length */
	};

	/*!
	 * @brief Function encrypts the given plain text with the given settings.
	 * @param	plainText		Raw data to encrypt
	 * @param	key				ByteArray with the key for encryption
	 * @param	keylength		The used length of the key
	 * @param	blockmode		The used encryption mode
	 * @param	NumberofBlocks	The count of blocks to encrypt, if 0 the count is calculated
	 * @returns The encrypted data
	 */
	static QByteArray AESEncryption(QByteArray plainText, QByteArray key, KeyLength keylength = Key128, BlockMode blockmode = CBC, quint64 NumberofBlocks = 0);

	/*!
	 * @brief Function decrypts the given encrypted text with the given settings.
	 * @param	encryptedText	Encrypted data to decrypt
	 * @param	key				ByteArray with the key for encryption
	 * @param	keylength		The used length of the key
	 * @param	blockmode		The used encryption mode
	 * @param	NumberofBlocks	The count of blocks to encrypt, if 0 the count is calculated
	 * @returns The plain text data
	 */
	static QByteArray AESDecryption(QByteArray encryptedText, QByteArray key, KeyLength keylength = Key128, BlockMode blockmode = CBC, quint64 NumberofBlocks = 0);

};




#endif 
